/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.gprinter.bean.PrinterDevices;
import com.gprinter.io.PortManager;
import com.gprinter.utils.CallbackListener;
import com.gprinter.utils.Command;
import com.gprinter.utils.GpUtils;
import com.gprinter.utils.HexUtils;
import com.gprinter.utils.LogUtils;
import com.gprinter.utils.PDFUtils;
import com.gprinter.utils.PrinterState;
import com.gprinter.utils.SDKUtils;
import com.gprinter.utils.UIThreadManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;

public class BleBlueToothPort
extends PortManager {
    private String TAG = BleBlueToothPort.class.getSimpleName();
    private String mac;
    private CallbackListener callbackListener;
    private Context context;
    private BluetoothAdapter bluetoothAdapter = null;
    private String SERVICES_UUID = "49535343-fe7d-4ae5-8fa9-9fafd205e455";
    private String WRITE_UUID = "49535343-8841-43f4-a8d4-ecbe34729bb3";
    private String NOTIFY_UUID = "49535343-1e4D-4bd9-ba61-23c647249616";
    private String NOTIFY_UUID2 = "49535343-1e4d-4bd9-ba61-23c647249616";
    private BluetoothGattCharacteristic writeCharacteristic;
    private BluetoothGattCharacteristic notifyCharacteristic;
    private BluetoothGatt bluetoothGatt;
    private Command command;
    private BluetoothDevice mDevices = null;
    private BleGattCallback mGattCallback;
    private int SINGLE_SIZE = 20;
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final Object lock = new Object();
    private PrinterDevices mPrinterDevices = null;
    private int id;

    public BleBlueToothPort(PrinterDevices printerDevices) {
        if (printerDevices != null) {
            this.mPrinterDevices = printerDevices;
            this.context = printerDevices.getContext();
            this.id = printerDevices.getId();
            this.mac = printerDevices.getMacAddress();
            this.command = printerDevices.getCommand();
            this.callbackListener = printerDevices.getCallbackListener();
            this.SINGLE_SIZE = printerDevices.getBle();
        }
    }

    private void setSuccessListen(Command command) {
        this.command = command;
        if (this.mPrinterDevices != null) {
            this.mPrinterDevices.setCommand(command);
        }
        if (this.callbackListener != null) {
            UIThreadManager.onUIThread(new Runnable(){

                @Override
                public void run() {
                    BleBlueToothPort.this.callbackListener.onSuccess(BleBlueToothPort.this.mPrinterDevices);
                }
            });
        }
    }

    private void setFailureListen() {
        if (this.callbackListener != null) {
            UIThreadManager.onUIThread(new Runnable(){

                @Override
                public void run() {
                    BleBlueToothPort.this.callbackListener.onFailure();
                }
            });
        }
    }

    private void checkPrinterCommand() throws IOException {
        int status = -1;
        status = this.getPrinterStatus(Command.ESC);
        if (status == -1) {
            status = this.getPrinterStatus(Command.CPCL);
            if (status == -1) {
                status = this.getPrinterStatus(Command.TSC);
                if (status == -1) {
                    status = this.getPrinterStatus(Command.ZPL);
                    if (status != -1) {
                        this.setSuccessListen(Command.ZPL);
                    } else {
                        this.setFailureListen();
                    }
                } else {
                    this.setSuccessListen(Command.TSC);
                }
            } else {
                this.setSuccessListen(Command.CPCL);
            }
        } else {
            this.setSuccessListen(Command.ESC);
        }
    }

    private void getFeasycomCharacteristic(BluetoothGattService service) {
        for (BluetoothGattCharacteristic characteristic : service.getCharacteristics()) {
            int charaProp = characteristic.getProperties();
            if ((charaProp & 0x10) != 0) {
                Log.e((String)this.TAG, (String)("\u53d1\u73b0NOTIFY\u7279\u5f81\u503c" + characteristic.getUuid().toString()));
                if (characteristic.getUuid().toString().equals(this.NOTIFY_UUID)) {
                    this.notifyCharacteristic = characteristic;
                } else {
                    Log.e((String)this.TAG, (String)"getFeasycomCharacteristic: 1");
                    Log.e((String)this.TAG, (String)"getFeasycomCharacteristic: 2");
                }
            }
            if ((charaProp & 8) == 0) continue;
            Log.e((String)this.TAG, (String)("\u53d1\u73b0Write Without Response\u7279\u5f81\u503c" + characteristic.getUuid().toString()));
            if (this.writeCharacteristic != null) continue;
            Log.e((String)this.TAG, (String)"setCharacteristic: ");
            this.writeCharacteristic = characteristic;
        }
        if (this.writeCharacteristic == null) {
            List characteristicList = service.getCharacteristics();
            for (BluetoothGattCharacteristic characteristic : characteristicList) {
                Log.e((String)this.TAG, (String)("\u53d1\u73b0Witer\u7279\u5f81\u503c" + characteristic.getUuid().toString()));
                int charaProp = characteristic.getProperties();
                if ((charaProp & 4) == 0) continue;
                Log.e((String)this.TAG, (String)"setCharacteristic: ");
                this.writeCharacteristic = characteristic;
            }
        }
    }

    private boolean enableNotification(boolean enable, BluetoothGattCharacteristic characteristic) {
        if (this.bluetoothGatt == null || characteristic == null) {
            return false;
        }
        if (!this.bluetoothGatt.setCharacteristicNotification(characteristic, enable)) {
            return false;
        }
        BluetoothGattDescriptor clientConfig = characteristic.getDescriptor(UUID.fromString(this.NOTIFY_UUID));
        if (clientConfig == null) {
            return false;
        }
        if (enable) {
            clientConfig.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
        } else {
            clientConfig.setValue(BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
        }
        return this.bluetoothGatt.writeDescriptor(clientConfig);
    }

    private boolean enableNotification2(boolean enable, BluetoothGattCharacteristic characteristic) {
        if (this.bluetoothGatt == null || characteristic == null) {
            return false;
        }
        if (!this.bluetoothGatt.setCharacteristicNotification(characteristic, enable)) {
            return false;
        }
        BluetoothGattDescriptor clientConfig = characteristic.getDescriptor(UUID.fromString("00002902-0000-1000-8000-00805f9b34fb"));
        if (clientConfig == null) {
            return false;
        }
        if (enable) {
            clientConfig.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
        } else {
            clientConfig.setValue(BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
        }
        return this.bluetoothGatt.writeDescriptor(clientConfig);
    }

    @Override
    public boolean openPort() {
        UIThreadManager.onUIThread(new Runnable(){

            @Override
            public void run() {
                if (BleBlueToothPort.this.callbackListener != null) {
                    BleBlueToothPort.this.callbackListener.onConnecting();
                }
            }
        });
        if (!this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            UIThreadManager.onUIThread(new Runnable(){

                @Override
                public void run() {
                    if (BleBlueToothPort.this.callbackListener != null) {
                        BleBlueToothPort.this.callbackListener.onFailure();
                    }
                }
            });
            return false;
        }
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.bluetoothAdapter == null || !this.bluetoothAdapter.isEnabled()) {
            UIThreadManager.onUIThread(new Runnable(){

                @Override
                public void run() {
                    if (BleBlueToothPort.this.callbackListener != null) {
                        BleBlueToothPort.this.callbackListener.onFailure();
                    }
                }
            });
            Log.e((String)this.TAG, (String)"The device does not support Bluetooth|BlueTooth no open\uff01");
            return false;
        }
        this.mDevices = this.bluetoothAdapter.getRemoteDevice(this.mac);
        this.mPrinterDevices.setBlueName(this.mDevices.getName());
        if (this.mDevices == null) {
            UIThreadManager.onUIThread(new Runnable(){

                @Override
                public void run() {
                    if (BleBlueToothPort.this.callbackListener != null) {
                        BleBlueToothPort.this.callbackListener.onFailure();
                    }
                }
            });
        }
        this.mGattCallback = new BleGattCallback();
        this.bluetoothGatt = Build.VERSION.SDK_INT >= 23 ? this.mDevices.connectGatt(this.context, false, (BluetoothGattCallback)this.mGattCallback, 2) : this.mDevices.connectGatt(this.context, false, (BluetoothGattCallback)this.mGattCallback);
        return false;
    }

    @Override
    public void setCommand(Command command) {
        this.command = command;
    }

    @Override
    public PrinterDevices getPrinterDevices() {
        return this.mPrinterDevices;
    }

    @Override
    public Command getCommand() {
        return this.command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlePack(int pack) {
        Object object = this.lock;
        synchronized (object) {
            this.SINGLE_SIZE = pack;
        }
    }

    @Override
    public boolean writeDataImmediately(byte[] data) throws IOException {
        if (this.writeCharacteristic == null) {
            Log.e((String)this.TAG, (String)"\u8bfb\u5199\u7279\u5f81\u503c\u4e3a\u7a7a,\u5c1d\u8bd5\u83b7\u53d6\u7279\u5f81\u503c");
            List<BluetoothGattService> list = this.getSupportedGattServices();
            for (int i = 0; i < list.size(); ++i) {
                this.getFeasycomCharacteristic(list.get(i));
            }
        }
        if (this.writeCharacteristic == null) {
            return false;
        }
        int offset = 0;
        List<byte[]> mlist = SDKUtils.getListByteArray(data, this.SINGLE_SIZE);
        int packNum = 0;
        while (packNum < mlist.size()) {
            if (this.writeCharacteristic == null) {
                Log.e((String)this.TAG, (String)"Interrupt transmission");
                break;
            }
            this.writeCharacteristic.setValue(mlist.get(packNum));
            boolean result = this.bluetoothGatt.writeCharacteristic(this.writeCharacteristic);
            Log.e((String)this.TAG, (String)("send result" + result));
            if (this.writeCharacteristic == null) {
                Log.e((String)this.TAG, (String)"Interrupt transmission");
                break;
            }
            if (result) {
                offset += mlist.get(packNum).length;
                ++packNum;
                continue;
            }
            Log.e((String)this.TAG, (String)"send error");
            try {
                Thread.sleep(15L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        mlist.clear();
        if (offset == data.length) {
            Log.e((String)this.TAG, (String)"send success");
            return true;
        }
        return false;
    }

    @Override
    @RequiresApi(api=21)
    public boolean writePDFToEsc(File file, int width) throws Exception {
        Bitmap[] bitmaps = PDFUtils.PDFToBitmap(file, width);
        if (bitmaps == null) {
            return false;
        }
        for (int i = 0; i < bitmaps.length; ++i) {
            byte[] data = PDFUtils.drawEscPDF(bitmaps[i]);
            this.writeDataImmediately(data);
            if (i != bitmaps.length - 1) continue;
            return true;
        }
        byte[] command = new byte[]{10, 29, 86, 66, 0, 27, 64};
        this.writeDataImmediately(command);
        return false;
    }

    @Override
    @RequiresApi(api=21)
    public boolean writePDFToTsc(File file, int printWidth, int gap, boolean cut, boolean dpi200, boolean compression, int cutHeight) throws Exception {
        if (file == null) {
            throw new Exception("File cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(printWidth))) {
            throw new Exception("printWidth cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(gap))) {
            throw new Exception("gap cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(cutHeight))) {
            throw new Exception("cutHeight cannot be empty");
        }
        Bitmap[] bitmaps = PDFUtils.PDFToBitmap(file, printWidth);
        if (bitmaps == null) {
            return false;
        }
        if (gap > 0 | cutHeight == 0) {
            for (int i = 0; i < bitmaps.length; ++i) {
                byte[] data;
                String size = "\r\nSIZE " + bitmaps[i].getWidth() / (dpi200 ? 8 : 12) + " mm," + bitmaps[i].getHeight() / (dpi200 ? 8 : 12) + " mm\r\n";
                this.writeDataImmediately(size.getBytes("GB18030"));
                String GAP = "GAP " + gap + " mm,0 mm\r\n";
                if (cut && i == bitmaps.length - 1) {
                    this.writeDataImmediately("SET CUTTER 1\r\n".getBytes("GB18030"));
                } else {
                    this.writeDataImmediately("SET CUTTER OFF\r\n".getBytes("GB18030"));
                }
                this.writeDataImmediately(GAP.getBytes("GB18030"));
                String cls = "CLS\r\n";
                this.writeDataImmediately(cls.getBytes("GB18030"));
                if (compression) {
                    data = PDFUtils.drawTscPDFLib(bitmaps[i]);
                    this.writeDataImmediately(data);
                } else {
                    data = PDFUtils.drawTscPDF(bitmaps[i]);
                    this.writeDataImmediately(data);
                }
                String print = "\r\nPRINT 1\r\n";
                this.writeDataImmediately(print.getBytes("GB18030"));
                if (i != bitmaps.length - 1) continue;
                return true;
            }
        } else {
            for (int i = 0; i < bitmaps.length; ++i) {
                List<Bitmap> mlist = BleBlueToothPort.ImageCrop(bitmaps[i], cutHeight);
                for (int j = 0; j < mlist.size(); ++j) {
                    byte[] data;
                    String size = "\r\nSIZE " + mlist.get(j).getWidth() / (dpi200 ? 8 : 12) + " mm," + mlist.get(j).getHeight() / (dpi200 ? 8 : 12) + " mm\r\n";
                    this.writeDataImmediately(size.getBytes("GB18030"));
                    String GAP = "GAP 0 mm,0 mm\r\n";
                    if (cut && j == mlist.size() - 1 && i == bitmaps.length - 1) {
                        this.writeDataImmediately("SET CUTTER 1\r\n".getBytes("GB18030"));
                    } else {
                        this.writeDataImmediately("SET CUTTER OFF\r\n".getBytes("GB18030"));
                    }
                    this.writeDataImmediately(GAP.getBytes("GB18030"));
                    String cls = "CLS\r\n";
                    this.writeDataImmediately(cls.getBytes("GB18030"));
                    if (compression) {
                        data = PDFUtils.drawTscPDFLib(mlist.get(j));
                        this.writeDataImmediately(data);
                    } else {
                        data = PDFUtils.drawTscPDF(mlist.get(j));
                        this.writeDataImmediately(data);
                    }
                    String print = "\r\nPRINT 1\r\n";
                    this.writeDataImmediately(print.getBytes("GB18030"));
                }
                if (i != bitmaps.length - 1) continue;
                mlist.clear();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean writeBitmapToTsc(Bitmap mBitmap, int printWidth, boolean cut, boolean dpi200, boolean compression, int cutHeight) throws Exception {
        if (mBitmap == null) {
            throw new Exception("Bitmap cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(printWidth))) {
            throw new Exception("printWidth cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(cutHeight))) {
            throw new Exception("cutHeight cannot be empty");
        }
        if (mBitmap != null) {
            int width = (printWidth + 7) / 8 * 8;
            int height = mBitmap.getHeight() * width / mBitmap.getWidth();
            Log.d((String)"BMP", (String)("bmp.getWidth() " + mBitmap.getWidth()));
            Bitmap rszBitmap = GpUtils.resizeImage(mBitmap, width, height);
            List<Bitmap> mlist = BleBlueToothPort.ImageCrop(rszBitmap, cutHeight);
            for (int j = 0; j < mlist.size(); ++j) {
                String size = "\r\nSIZE " + mlist.get(j).getWidth() / (dpi200 ? 8 : 12) + " mm," + mlist.get(j).getHeight() / (dpi200 ? 8 : 12) + " mm\r\n";
                this.writeDataImmediately(size.getBytes("GB18030"));
                String gap = "GAP 0 mm,0 mm\r\n";
                this.writeDataImmediately(gap.getBytes("GB18030"));
                if (cut && j == mlist.size() - 1) {
                    this.writeDataImmediately("SET CUTTER 1\r\n".getBytes("GB18030"));
                } else {
                    this.writeDataImmediately("SET CUTTER OFF\r\n".getBytes("GB18030"));
                }
                String cls = "CLS\r\n";
                this.writeDataImmediately(cls.getBytes("GB18030"));
                byte[] data = PDFUtils.drawTscPDFLib(mlist.get(j));
                this.writeDataImmediately(data);
                String print = "\r\nPRINT 1\r\n";
                this.writeDataImmediately(print.getBytes("GB18030"));
                if (j != mlist.size() - 1) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Bitmap> ImageCrop(Bitmap bitmap, int photoheight) {
        ArrayList<Bitmap> list = new ArrayList<Bitmap>();
        int last = bitmap.getHeight() % photoheight;
        for (int i = 0; i < bitmap.getHeight() - bitmap.getHeight() % photoheight; i += photoheight) {
            list.add(BleBlueToothPort.cutBitmap(bitmap, i, photoheight));
        }
        if (last > 0) {
            Bitmap cp = BleBlueToothPort.cutBitmap(bitmap, bitmap.getHeight() - bitmap.getHeight() % photoheight, bitmap.getHeight() % photoheight);
            list.add(cp);
        }
        return list;
    }

    public static Bitmap cutBitmap(Bitmap bitmap, int y, int height) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Log.e((String)String.valueOf(w), (String)String.valueOf(h));
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)y, (int)w, (int)height, null, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPrinterStatus(Command command) throws IOException {
        if (command == null) {
            return -1;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.byteArrayOutputStream.size() > 0) {
                this.byteArrayOutputStream.reset();
            }
        }
        switch (command) {
            case ESC: {
                byte[] esc = new byte[]{16, 4, 2};
                this.writeDataImmediately(esc);
                break;
            }
            case TSC: {
                byte[] tsc = new byte[]{27, 33, 63, 13, 10};
                this.writeDataImmediately(tsc);
                break;
            }
            case CPCL: {
                byte[] cpcl = new byte[]{27, 104};
                this.writeDataImmediately(cpcl);
                break;
            }
            case ZPL: {
                byte[] zpl = "~HS".getBytes();
                this.writeDataImmediately(zpl);
            }
        }
        long endTime = SystemClock.elapsedRealtime() + 2000L;
        byte[] recv = new byte[1];
        int len = 0;
        if (this.writeCharacteristic == null) {
            while (len <= 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (endTime > SystemClock.elapsedRealtime()) continue;
                break;
            }
        } else {
            Object object2 = this.lock;
            synchronized (object2) {
                if (command == Command.ZPL) {
                    while (endTime > SystemClock.elapsedRealtime()) {
                        try {
                            this.lock.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    while (this.byteArrayOutputStream.size() == 0 && endTime > SystemClock.elapsedRealtime()) {
                        try {
                            this.lock.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (this.byteArrayOutputStream != null && this.byteArrayOutputStream.size() > 0) {
                    len = this.byteArrayOutputStream.size();
                    recv = this.byteArrayOutputStream.toByteArray();
                }
            }
        }
        if (len > 0) {
            return PrinterState.resolveData(recv, command);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPower() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.byteArrayOutputStream.size() > 0) {
                this.byteArrayOutputStream.reset();
            }
        }
        byte[] command = new byte[]{31, 27, 31, -88, 16, 17, 18, 19, 20, 21, 119};
        this.writeDataImmediately(command);
        long endTime = SystemClock.elapsedRealtime() + 2000L;
        byte[] recv = new byte[1];
        int len = 0;
        if (this.writeCharacteristic == null) {
            while (len <= 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (endTime > SystemClock.elapsedRealtime()) continue;
                break;
            }
        } else {
            Object object2 = this.lock;
            synchronized (object2) {
                while (this.byteArrayOutputStream.size() == 0 && endTime > SystemClock.elapsedRealtime()) {
                    try {
                        this.lock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.byteArrayOutputStream != null && this.byteArrayOutputStream.size() > 0) {
                    len = this.byteArrayOutputStream.size();
                    recv = this.byteArrayOutputStream.toByteArray();
                }
            }
            LogUtils.e("status" + len);
        }
        if (len > 0) {
            if (recv[0] == 49) {
                return 1;
            }
            if (recv[0] == 50) {
                return 2;
            }
            if (recv[0] == 51) {
                return 3;
            }
            if (recv[0] == 52) {
                return 4;
            }
            if (recv[0] == 53) {
                return 5;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrinterModel(Command command) throws IOException {
        if (command == null) {
            return "";
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.byteArrayOutputStream.size() > 0) {
                this.byteArrayOutputStream.reset();
            }
        }
        switch (command) {
            case ESC: {
                byte[] esc = new byte[]{29, 73, 67};
                this.writeDataImmediately(esc);
                break;
            }
            case TSC: {
                byte[] tsc = new byte[]{126, 33, 84, 13, 10};
                this.writeDataImmediately(tsc);
                break;
            }
            case CPCL: {
                byte[] cpcl = new byte[]{27, 118};
                this.writeDataImmediately(cpcl);
            }
        }
        long endTime = SystemClock.elapsedRealtime() + 2000L;
        byte[] recv = new byte[32];
        int len = 0;
        if (this.writeCharacteristic == null) {
            while (len <= 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (endTime > SystemClock.elapsedRealtime()) continue;
                break;
            }
        } else {
            Object object2 = this.lock;
            synchronized (object2) {
                while (endTime > SystemClock.elapsedRealtime()) {
                    try {
                        this.lock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.byteArrayOutputStream != null && this.byteArrayOutputStream.size() > 0) {
                    len = this.byteArrayOutputStream.size();
                    recv = this.byteArrayOutputStream.toByteArray();
                }
            }
            LogUtils.e("status" + len);
        }
        if (recv.length > 0) {
            return new String(recv);
        }
        return null;
    }

    @Override
    public boolean writeDataImmediately(Vector<Byte> sendData) throws IOException {
        if (this.writeCharacteristic == null) {
            Log.e((String)this.TAG, (String)"\u8bfb\u5199\u7279\u5f81\u503c\u4e3a\u7a7a,\u5c1d\u8bd5\u83b7\u53d6\u7279\u5f81\u503c");
            List<BluetoothGattService> list = this.getSupportedGattServices();
            for (int i = 0; i < list.size(); ++i) {
                this.getFeasycomCharacteristic(list.get(i));
            }
        }
        if (this.writeCharacteristic == null) {
            return false;
        }
        int offset = 0;
        byte[] data = SDKUtils.convertVectorByteToBytes(sendData);
        List<byte[]> mlist = SDKUtils.getListByteArray(data, this.SINGLE_SIZE);
        int packNum = 0;
        while (packNum < mlist.size()) {
            this.writeCharacteristic.setValue(mlist.get(packNum));
            boolean result = this.bluetoothGatt.writeCharacteristic(this.writeCharacteristic);
            Log.e((String)this.TAG, (String)("send result" + result));
            if (result) {
                offset += mlist.get(packNum).length;
                ++packNum;
            } else {
                Log.e((String)this.TAG, (String)"send error");
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.writeCharacteristic != null) continue;
            Log.e((String)this.TAG, (String)"Interrupt transmission");
            break;
        }
        sendData.clear();
        mlist.clear();
        if (offset == data.length) {
            Log.e((String)this.TAG, (String)"send success");
            return true;
        }
        return false;
    }

    public List<BluetoothGattService> getSupportedGattServices() {
        if (this.bluetoothGatt == null) {
            return null;
        }
        return this.bluetoothGatt.getServices();
    }

    @Override
    public int readData(byte[] bytes) throws IOException {
        return super.readData(bytes);
    }

    @Override
    @RequiresApi(api=18)
    public synchronized boolean closePort() {
        Log.e((String)this.TAG, (String)"closePort BLE_BLUETooth");
        this.mPrinterDevices = null;
        this.writeCharacteristic = null;
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.disconnect();
            this.bluetoothGatt.close();
        }
        return true;
    }

    private class BleGattCallback
    extends BluetoothGattCallback {
        private BleGattCallback() {
        }

        public void onConnectionStateChange(BluetoothGatt gatt, final int status, final int newState) {
            if (BleBlueToothPort.this.callbackListener != null) {
                UIThreadManager.onUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (status == 0) {
                            switch (newState) {
                                case 1: {
                                    BleBlueToothPort.this.callbackListener.onConnecting();
                                    break;
                                }
                                case 2: {
                                    BleBlueToothPort.this.bluetoothGatt.discoverServices();
                                }
                            }
                            return;
                        }
                        if (status == 8) {
                            BleBlueToothPort.this.closePort();
                            String err = "Cannot connect device with error status: " + status;
                            Log.e((String)BleBlueToothPort.this.TAG, (String)err);
                            BleBlueToothPort.this.callbackListener.onDisconnect();
                        } else {
                            BleBlueToothPort.this.closePort();
                            String err = "Cannot connect device with error status: " + status;
                            Log.e((String)BleBlueToothPort.this.TAG, (String)err);
                            BleBlueToothPort.this.callbackListener.onFailure();
                        }
                    }
                });
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            super.onServicesDiscovered(gatt, status);
            List services = BleBlueToothPort.this.bluetoothGatt.getServices();
            for (int i = 0; i < services.size(); ++i) {
                BluetoothGattService bluetoothGattService = (BluetoothGattService)services.get(i);
                for (BluetoothGattCharacteristic characteristic : bluetoothGattService.getCharacteristics()) {
                    int charaProp = characteristic.getProperties();
                    if ((charaProp & 0x10) != 0) {
                        boolean result;
                        Log.e((String)BleBlueToothPort.this.TAG, (String)("\u53d1\u73b0NOTIFY\u7279\u5f81\u503c" + characteristic.getUuid().toString()));
                        if (characteristic.getUuid().toString().equals(BleBlueToothPort.this.NOTIFY_UUID2)) {
                            Log.e((String)BleBlueToothPort.this.TAG, (String)("\u8bbe\u7f6e\u98de\u6613\u901aNOTIFY\u7279\u5f81\u503c" + characteristic.getUuid().toString()));
                            BleBlueToothPort.this.notifyCharacteristic = characteristic;
                            result = BleBlueToothPort.this.enableNotification2(true, BleBlueToothPort.this.notifyCharacteristic);
                            Log.e((String)BleBlueToothPort.this.TAG, (String)("\u8bbe\u7f6e\u901a\u77e5\t" + result));
                            if (Build.VERSION.SDK_INT >= 21) {
                                BleBlueToothPort.this.bluetoothGatt.requestMtu(103);
                            }
                        } else {
                            Log.e((String)BleBlueToothPort.this.TAG, (String)("\u8bbe\u7f6e\u5176\u4ed6NOTIFY\u7279\u5f81\u503c" + characteristic.getUuid().toString()));
                            BleBlueToothPort.this.notifyCharacteristic = characteristic;
                            result = BleBlueToothPort.this.enableNotification(true, BleBlueToothPort.this.notifyCharacteristic);
                            Log.e((String)BleBlueToothPort.this.TAG, (String)("\u8bbe\u7f6e\u901a\u77e5\t" + result));
                        }
                    }
                    if ((charaProp & 8) == 0) continue;
                    Log.e((String)BleBlueToothPort.this.TAG, (String)("\u53d1\u73b0Write\u7279\u5f81\u503c" + characteristic.getUuid().toString()));
                    if (characteristic.getUuid().toString().equals(BleBlueToothPort.this.WRITE_UUID)) {
                        Log.e((String)BleBlueToothPort.this.TAG, (String)("\u8bbe\u7f6e\u98de\u6613\u901aWrite\u7279\u5f81\u503c" + characteristic.getUuid().toString()));
                        BleBlueToothPort.this.writeCharacteristic = characteristic;
                        continue;
                    }
                    Log.e((String)BleBlueToothPort.this.TAG, (String)("\u8bbe\u7f6e\u5176\u4ed6Write\u7279\u5f81\u503c\uff1a" + characteristic));
                    BleBlueToothPort.this.writeCharacteristic = characteristic;
                }
            }
            if (BleBlueToothPort.this.notifyCharacteristic != null) {
                Log.e((String)BleBlueToothPort.this.TAG, (String)"\u83b7\u53d6writeCharacteristic\u6210\u529f");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (BleBlueToothPort.this.callbackListener != null) {
                            if (BleBlueToothPort.this.command == null) {
                                UIThreadManager.onUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        BleBlueToothPort.this.callbackListener.onCheckCommand();
                                    }
                                });
                                try {
                                    BleBlueToothPort.this.checkPrinterCommand();
                                }
                                catch (IOException iOException) {}
                            } else {
                                BleBlueToothPort.this.setSuccessListen(BleBlueToothPort.this.command);
                            }
                        }
                    }
                }).start();
            } else {
                Log.e((String)BleBlueToothPort.this.TAG, (String)"\u83b7\u53d6writeCharacteristic\u5931\u8d25");
                BleBlueToothPort.this.setFailureListen();
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicRead(gatt, characteristic, status);
            byte[] rec = characteristic.getValue();
            Log.e((String)BleBlueToothPort.this.TAG, (String)("\u8bfbBLE:\n" + new String(rec)));
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicWrite(gatt, characteristic, status);
            if (status == 0) {
                byte[] rec = characteristic.getValue();
                Log.e((String)BleBlueToothPort.this.TAG, (String)("\u5df2\u53d1\u9001:\t" + HexUtils.byte2HexStr(rec)));
            } else {
                Log.e((String)BleBlueToothPort.this.TAG, (String)"Send data failed!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            super.onCharacteristicChanged(gatt, characteristic);
            Object object = BleBlueToothPort.this.lock;
            synchronized (object) {
                final byte[] rec = characteristic.getValue();
                Log.e((String)BleBlueToothPort.this.TAG, (String)("BLE:\n" + new String(rec)));
                UIThreadManager.onUIThread(new Runnable(){

                    @Override
                    public void run() {
                        BleBlueToothPort.this.callbackListener.onReceive(rec);
                    }
                });
                if (rec.length > 0) {
                    try {
                        BleBlueToothPort.this.byteArrayOutputStream.write(rec);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    BleBlueToothPort.this.lock.notifyAll();
                }
            }
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            super.onDescriptorRead(gatt, descriptor, status);
            Log.e((String)BleBlueToothPort.this.TAG, (String)("onDescriptorRead" + String.format("%02X", new Object[]{descriptor.getValue()})));
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            super.onDescriptorWrite(gatt, descriptor, status);
            if (Build.VERSION.SDK_INT >= 21) {
                gatt.requestMtu(103);
            }
        }

        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            Log.e((String)BleBlueToothPort.this.TAG, (String)("mtu" + mtu));
            if (status == 0 && mtu > BleBlueToothPort.this.SINGLE_SIZE) {
                BleBlueToothPort.this.SINGLE_SIZE = mtu - 3;
                Log.e((String)BleBlueToothPort.this.TAG, (String)("\u8bbe\u7f6e\u6bcf\u5305\u53d1\u9001\u5927\u5c0f\uff1a" + BleBlueToothPort.this.SINGLE_SIZE));
            }
        }
    }
}

